<?php

require_once('sugar_version.php');

global $sugar_config, $db;
$sugar_config['default_max_tabs'] = 10;
$sugar_config['suitecrm_version'] = '7.0.2';
$sugar_config['sugar_version'] = $sugar_version;
$sugar_config['default_theme'] = 'Suite7';
$sugar_config['sugarbeet'] = false;
$sugar_config['languages']['es_es'] = 'Español (ES)';
$sugar_config['languages']['ru_ru'] = 'Русский (RU)';

ksort($sugar_config);
write_array_to_file('sugar_config', $sugar_config, 'config.php');
require_once('modules/Administration/updater_utils.php');
set_CheckUpdates_config_setting('manual');

require_once('modules/Users/User.php');
$query = "SELECT id FROM users WHERE deleted = 0";
$result = $db->query($query, true, "Unable to update User prefs ");
while ($row = $db->fetchByAssoc($result)) {

    $current_user = new User();
    $current_user->retrieve($row['id']);
    $current_user->setPreference('user_theme', 'Suite7');
    $current_user->setPreference('max_tabs', '10');
    $current_user->savePreferencesToDB();

}


require_once(clean_path($unzip_dir.'/scripts/suite_install/AdvancedOpenWorkflow.php'));
install_aow();

require_once(clean_path($unzip_dir.'/scripts/suite_install/AdvancedOpenSales.php'));
upgrade_aos();
install_aos();

require_once(clean_path($unzip_dir.'/scripts/suite_install/AdvancedOpenPortal.php'));
install_aop();

require_once(clean_path($unzip_dir.'/scripts/suite_install/AdvancedOpenEvents.php'));
install_aoe();

require_once(clean_path($unzip_dir.'/scripts/suite_install/Reschedule.php'));
install_reschedule();

require_once(clean_path($unzip_dir.'/scripts/suite_install/SecurityGroups.php'));
install_ss();

require_once(clean_path($unzip_dir.'/scripts/suite_install/GoogleMaps.php'));
install_gmaps();

$installed_modules = array();
$installed_modules[] = 'AOS_Quotes';
$installed_modules[] = 'AOS_Invoices';
$installed_modules[] = 'AOS_Contracts';
$installed_modules[] = 'FP_events';
$installed_modules[] = 'FP_Event_Locations';
$installed_modules[] = 'AOS_Products';
$installed_modules[] = 'AOS_Product_Categories';
$installed_modules[] = 'AOS_PDF_Templates';
$installed_modules[] = 'jjwg_Maps';
$installed_modules[] = 'jjwg_Markers';
$installed_modules[] = 'jjwg_Areas';
$installed_modules[] = 'jjwg_Address_Cache';
$installed_modules[] = 'AOR_Reports';
$installed_modules[] = 'AOW_WorkFlow';

include_once('ModuleInstall/ModuleInstaller.php');
UpdateSystemTabs('Add', $installed_modules);
